/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.functions;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.functions.Function;
import org.icepdf.core.pobjects.functions.postscript.Lexer;
import org.icepdf.core.util.Utils;

public class Function_4
extends Function {
    private static final Logger logger = Logger.getLogger(Function_4.class.toString());
    private byte[] functionContent;
    private HashMap<Integer, float[]> resultCache;

    public Function_4(Dictionary d) {
        super(d);
        if (d instanceof Stream) {
            Stream functionStream = (Stream)d;
            this.functionContent = functionStream.getDecodedStreamBytes(0);
            if (logger.isLoggable(Level.FINER)) {
                logger.finest("Function 4: " + Utils.convertByteArrayToByteString(this.functionContent));
            }
        } else {
            logger.warning("Type 4 function operands could not be found.");
        }
        this.resultCache = new HashMap();
    }

    public float[] calculate(float[] x) {
        Integer colourKey = this.calculateColourKey(x);
        float[] result = this.resultCache.get(colourKey);
        if (result != null) {
            return result;
        }
        ByteArrayInputStream content = new ByteArrayInputStream(this.functionContent);
        Lexer lex = new Lexer();
        lex.setInputStream(content);
        try {
            lex.parse(x);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error Processing Type 4 definition", e);
        }
        Stack stack = lex.getStack();
        int n = this.range.length / 2;
        float[] y = new float[n];
        for (int i = 0; i < n; ++i) {
            y[i] = Math.min(Math.max(((Float)stack.elementAt(i)).floatValue(), this.range[2 * i]), this.range[2 * i + 1]);
        }
        this.resultCache.put(colourKey, y);
        return y;
    }

    private Integer calculateColourKey(float[] colours) {
        int length = colours.length;
        if (!((double)colours[0] <= 1.0)) {
            if (length == 1) {
                return (int)colours[0];
            }
            if (length == 2) {
                return (int)colours[1] << 8 | (int)colours[0];
            }
            if (length == 3) {
                return (int)colours[2] << 16 | (int)colours[1] << 8 | (int)colours[0];
            }
        }
        StringBuilder builder = new StringBuilder();
        for (float colour : colours) {
            builder.append(colour);
        }
        return builder.toString().hashCode();
    }
}

