/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel.util;

import de.muntjak.tinylookandfeel.util.HSBReference;
import java.awt.Color;

public class ColorRoutines {
    private static final int RGB = 1;
    private static final int RBG = 2;
    private static final int GBR = 3;
    private static final int GRB = 4;
    private static final int BRG = 5;
    private static final int BGR = 6;
    private static float[] hsb = new float[3];
    private boolean preserveGrey;
    private int chue;
    private int csat;
    private int cbri;
    private int fr;
    private int fg;
    private int fb;
    private int hi;
    private int lo;
    private int md;
    private boolean hiIsR;
    private boolean hiIsG;
    private boolean hiIsB;
    private boolean mdIsR;
    private boolean mdIsG;
    private boolean mdIsB;
    private boolean loIsR;
    private boolean loIsG;
    private boolean loIsB;

    ColorRoutines(HSBReference hSBReference) {
        this.chue = hSBReference.hue;
        this.csat = hSBReference.getSaturation();
        this.cbri = hSBReference.getBrightness();
        this.preserveGrey = hSBReference.isPreserveGrey();
        Color color = Color.getHSBColor((float)((double)this.chue / 360.0), 1.0f, 1.0f);
        this.fr = color.getRed();
        this.fg = color.getGreen();
        this.fb = color.getBlue();
        if (this.fr >= this.fg && this.fg >= this.fb) {
            this.hi = this.fr;
            this.md = this.fg;
            this.lo = this.fb;
            this.hiIsR = true;
            this.mdIsG = true;
            this.loIsB = true;
        } else if (this.fr >= this.fb && this.fb >= this.fg) {
            this.hi = this.fr;
            this.md = this.fb;
            this.lo = this.fg;
            this.hiIsR = true;
            this.mdIsB = true;
            this.loIsG = true;
        } else if (this.fg >= this.fr && this.fr >= this.fb) {
            this.hi = this.fg;
            this.md = this.fr;
            this.lo = this.fb;
            this.hiIsG = true;
            this.mdIsR = true;
            this.loIsB = true;
        } else if (this.fg >= this.fb && this.fb >= this.fr) {
            this.hi = this.fg;
            this.md = this.fb;
            this.lo = this.fr;
            this.hiIsG = true;
            this.mdIsB = true;
            this.loIsR = true;
        } else if (this.fb >= this.fg && this.fg >= this.fr) {
            this.hi = this.fb;
            this.md = this.fg;
            this.lo = this.fr;
            this.hiIsB = true;
            this.mdIsG = true;
            this.loIsR = true;
        } else if (this.fb >= this.fr && this.fr >= this.fg) {
            this.hi = this.fb;
            this.md = this.fr;
            this.lo = this.fg;
            this.hiIsB = true;
            this.mdIsR = true;
            this.loIsG = true;
        }
    }

    private void setHSB(int n, int n2, int n3) {
        this.chue = ColorRoutines.getHue(n, n2, n3);
        this.csat = ColorRoutines.getSaturation(n, n2, n3);
        this.cbri = ColorRoutines.getBrightness(n, n2, n3);
    }

    public static Color getAverage(Color color, Color color2) {
        int n = (int)Math.round((double)(color.getRed() + color2.getRed()) / 2.0);
        int n2 = (int)Math.round((double)(color.getGreen() + color2.getGreen()) / 2.0);
        int n3 = (int)Math.round((double)(color.getBlue() + color2.getBlue()) / 2.0);
        return new Color(n, n2, n3);
    }

    public static Color getGradient(Color color, Color color2, int n, int n2) {
        if (n2 == 0) {
            return color;
        }
        if (n2 == n) {
            return color2;
        }
        double d = (double)n2 * 1.1 / (double)n;
        double d2 = 1.0 - d;
        int n3 = (int)Math.round((double)color.getRed() * d2 + (double)color2.getRed() * d);
        int n4 = (int)Math.round((double)color.getGreen() * d2 + (double)color2.getGreen() * d);
        int n5 = (int)Math.round((double)color.getBlue() * d2 + (double)color2.getBlue() * d);
        return new Color(n3, n4, n5);
    }

    private static Color getMaxSaturation(Color color, int n) {
        int n2 = color.getRed();
        int n3 = color.getGreen();
        int n4 = color.getBlue();
        if (n2 == n3 && n2 == n4) {
            return color;
        }
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 1;
        if (n2 >= n3 && n2 >= n4) {
            n7 = n2;
            if (n3 == n4) {
                n5 = n3;
                n6 = n4;
                n8 = 1;
            } else if (n3 > n4) {
                n5 = n3;
                n6 = n4;
                n8 = 1;
            } else {
                n6 = n3;
                n5 = n4;
                n8 = 2;
            }
        } else if (n3 >= n2 && n3 >= n4) {
            n7 = n3;
            if (n2 == n4) {
                n5 = n2;
                n6 = n4;
                n8 = 4;
            } else if (n2 > n4) {
                n5 = n2;
                n6 = n4;
                n8 = 4;
            } else {
                n6 = n2;
                n5 = n4;
                n8 = 3;
            }
        } else if (n4 >= n2 && n4 >= n3) {
            n7 = n4;
            if (n2 == n3) {
                n5 = n2;
                n6 = n3;
                n8 = 5;
            } else if (n2 > n3) {
                n5 = n2;
                n6 = n3;
                n8 = 5;
            } else {
                n6 = n2;
                n5 = n3;
                n8 = 6;
            }
        }
        if (n6 == 0) {
            return color;
        }
        int n9 = Math.min(255, n7 + n6);
        int n10 = Math.max(0, n7 + n6 - 255);
        int n11 = n5;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 360;
        Color color2 = null;
        switch (n8) {
            case 1: {
                n13 = n12 = ColorRoutines.getHue(n9, n11, n10);
                while (n12 != n && n11 < 256) {
                    n12 = ColorRoutines.getHue(n9, ++n11, n10);
                    if (n11 == 256) break;
                    if (n12 == n) {
                        return new Color(n9, n11, n10);
                    }
                    if (n13 < n && n12 > n || n13 > n && n12 < n) {
                        return new Color(n9, n11, n10);
                    }
                    if (Math.abs(n12 - n) < n15) {
                        n15 = Math.abs(n12 - n);
                        n14 = n11;
                    }
                    n13 = n12;
                }
                if (n12 != n) {
                    n13 = n12 = ColorRoutines.getHue(n9, n11, n10);
                    n11 = n5;
                    while (n12 != n && n11 >= 0) {
                        n12 = ColorRoutines.getHue(n9, --n11, n10);
                        if (n11 == -1) break;
                        if (n12 == n) {
                            return new Color(n9, n11, n10);
                        }
                        if (n13 < n && n12 > n || n13 > n && n12 < n) {
                            return new Color(n9, n11, n10);
                        }
                        if (Math.abs(n12 - n) < n15) {
                            n15 = Math.abs(n12 - n);
                            n14 = n11;
                        }
                        n13 = n12;
                    }
                }
                if (n11 == 256 | n11 == -1) {
                    n11 = n14;
                }
                color2 = new Color(n9, n11, n10);
                break;
            }
            case 2: {
                n13 = n12 = ColorRoutines.getHue(n9, n10, n11);
                while (n12 != n && n11 < 256) {
                    n12 = ColorRoutines.getHue(n9, n10, ++n11);
                    if (n11 == 256) break;
                    if (n12 == n) {
                        return new Color(n9, n10, n11);
                    }
                    if (n13 < n && n12 > n || n13 > n && n12 < n) {
                        return new Color(n9, n10, n11);
                    }
                    if (Math.abs(n12 - n) < n15) {
                        n15 = Math.abs(n12 - n);
                        n14 = n11;
                    }
                    n13 = n12;
                }
                if (n12 != n) {
                    n13 = n12 = ColorRoutines.getHue(n9, n11, n10);
                    n11 = n5;
                    while (n12 != n && n11 >= 0) {
                        n12 = ColorRoutines.getHue(n9, n10, --n11);
                        if (n11 == -1) break;
                        if (n12 == n) {
                            return new Color(n9, n10, n11);
                        }
                        if (n13 < n && n12 > n || n13 > n && n12 < n) {
                            return new Color(n9, n10, n11);
                        }
                        if (Math.abs(n12 - n) < n15) {
                            n15 = Math.abs(n12 - n);
                            n14 = n11;
                        }
                        n13 = n12;
                    }
                }
                if (n11 == 256 | n11 == -1) {
                    n11 = n14;
                }
                color2 = new Color(n9, n10, n11);
                break;
            }
            case 3: {
                n13 = n12 = ColorRoutines.getHue(n10, n9, n11);
                while (n12 != n && n11 < 256) {
                    n12 = ColorRoutines.getHue(n10, n9, ++n11);
                    if (n11 == 256) break;
                    if (n12 == n) {
                        return new Color(n10, n9, n11);
                    }
                    if (n13 < n && n12 > n || n13 > n && n12 < n) {
                        return new Color(n10, n9, n11);
                    }
                    if (Math.abs(n12 - n) < n15) {
                        n15 = Math.abs(n12 - n);
                        n14 = n11;
                    }
                    n13 = n12;
                }
                if (n12 != n) {
                    n13 = n12 = ColorRoutines.getHue(n9, n11, n10);
                    n11 = n5;
                    while (n12 != n && n11 >= 0) {
                        n12 = ColorRoutines.getHue(n10, n9, --n11);
                        if (n11 == -1) break;
                        if (n12 == n) {
                            return new Color(n10, n9, n11);
                        }
                        if (n13 < n && n12 > n || n13 > n && n12 < n) {
                            return new Color(n10, n9, n11);
                        }
                        if (Math.abs(n12 - n) < n15) {
                            n15 = Math.abs(n12 - n);
                            n14 = n11;
                        }
                        n13 = n12;
                    }
                }
                if (n11 == 256 | n11 == -1) {
                    n11 = n14;
                }
                color2 = new Color(n10, n9, n11);
                break;
            }
            case 4: {
                n13 = n12 = ColorRoutines.getHue(n11, n9, n10);
                while (n12 != n && n11 < 256) {
                    n12 = ColorRoutines.getHue(++n11, n9, n10);
                    if (n11 == 256) break;
                    if (n12 == n) {
                        return new Color(n11, n9, n10);
                    }
                    if (n13 < n && n12 > n || n13 > n && n12 < n) {
                        return new Color(n11, n9, n10);
                    }
                    if (Math.abs(n12 - n) < n15) {
                        n15 = Math.abs(n12 - n);
                        n14 = n11;
                    }
                    n13 = n12;
                }
                if (n12 != n) {
                    n13 = n12 = ColorRoutines.getHue(n9, n11, n10);
                    n11 = n5;
                    while (n12 != n && n11 >= 0) {
                        n12 = ColorRoutines.getHue(--n11, n9, n10);
                        if (n11 == -1) break;
                        if (n12 == n) {
                            return new Color(n11, n9, n10);
                        }
                        if (n13 < n && n12 > n || n13 > n && n12 < n) {
                            return new Color(n11, n9, n10);
                        }
                        if (Math.abs(n12 - n) < n15) {
                            n15 = Math.abs(n12 - n);
                            n14 = n11;
                        }
                        n13 = n12;
                    }
                }
                if (n11 == 256 | n11 == -1) {
                    n11 = n14;
                }
                color2 = new Color(n11, n9, n10);
                break;
            }
            case 5: {
                n13 = n12 = ColorRoutines.getHue(n11, n10, n9);
                while (n12 != n && n11 < 256) {
                    n12 = ColorRoutines.getHue(++n11, n10, n9);
                    if (n11 == 256) break;
                    if (n12 == n) {
                        return new Color(n11, n10, n9);
                    }
                    if (n13 < n && n12 > n || n13 > n && n12 < n) {
                        return new Color(n11, n10, n9);
                    }
                    if (Math.abs(n12 - n) < n15) {
                        n15 = Math.abs(n12 - n);
                        n14 = n11;
                    }
                    n13 = n12;
                }
                if (n12 != n) {
                    n13 = n12 = ColorRoutines.getHue(n9, n11, n10);
                    n11 = n5;
                    while (n12 != n && n11 >= 0) {
                        n12 = ColorRoutines.getHue(--n11, n10, n9);
                        if (n11 == -1) break;
                        if (n12 == n) {
                            return new Color(n11, n10, n9);
                        }
                        if (n13 < n && n12 > n || n13 > n && n12 < n) {
                            return new Color(n11, n10, n9);
                        }
                        if (Math.abs(n12 - n) < n15) {
                            n15 = Math.abs(n12 - n);
                            n14 = n11;
                        }
                        n13 = n12;
                    }
                }
                if (n11 == 256 | n11 == -1) {
                    n11 = n14;
                }
                color2 = new Color(n11, n10, n9);
                break;
            }
            case 6: {
                n13 = n12 = ColorRoutines.getHue(n10, n11, n9);
                while (n12 != n && n11 < 256) {
                    n12 = ColorRoutines.getHue(n10, ++n11, n9);
                    if (n11 == 256) break;
                    if (n12 == n) {
                        return new Color(n10, n11, n9);
                    }
                    if (n13 < n && n12 > n || n13 > n && n12 < n) {
                        return new Color(n10, n11, n9);
                    }
                    if (Math.abs(n12 - n) < n15) {
                        n15 = Math.abs(n12 - n);
                        n14 = n11;
                    }
                    n13 = n12;
                }
                if (n12 != n) {
                    n13 = n12 = ColorRoutines.getHue(n9, n11, n10);
                    n11 = n5;
                    while (n12 != n && n11 >= 0) {
                        n12 = ColorRoutines.getHue(n10, --n11, n9);
                        if (n11 == -1) break;
                        if (n12 == n) {
                            return new Color(n10, n11, n9);
                        }
                        if (n13 < n && n12 > n || n13 > n && n12 < n) {
                            return new Color(n10, n11, n9);
                        }
                        if (Math.abs(n12 - n) < n15) {
                            n15 = Math.abs(n12 - n);
                            n14 = n11;
                        }
                        n13 = n12;
                    }
                }
                if (n11 == 256 | n11 == -1) {
                    n11 = n14;
                }
                color2 = new Color(n10, n11, n9);
            }
        }
        return color2;
    }

    private static float getGreyValue(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (n >= n2 && n >= n3) {
            if (n == 0) {
                return 0.0f;
            }
            n6 = n;
            if (n2 >= n3) {
                n4 = n2;
                n5 = n3;
            } else {
                n5 = n2;
                n4 = n3;
            }
        } else if (n2 >= n && n2 >= n3) {
            n6 = n2;
            if (n >= n3) {
                n4 = n;
                n5 = n3;
            } else {
                n5 = n;
                n4 = n3;
            }
        } else if (n3 >= n && n3 >= n2) {
            n6 = n3;
            if (n >= n2) {
                n4 = n;
                n5 = n2;
            } else {
                n5 = n;
                n4 = n2;
            }
        }
        return (float)((double)(n6 + n5) / 2.0);
    }

    public static int getBrightness(Color color) {
        return ColorRoutines.getBrightness(color.getRed(), color.getGreen(), color.getBlue());
    }

    private static int getBrightness(int n, int n2, int n3) {
        if (n >= n2 && n >= n3) {
            return (int)Math.round((double)(100 * n) / 255.0);
        }
        if (n2 >= n && n2 >= n3) {
            return (int)Math.round((double)(100 * n2) / 255.0);
        }
        if (n3 >= n && n3 >= n2) {
            return (int)Math.round((double)(100 * n3) / 255.0);
        }
        return -1;
    }

    public static int getSaturation(Color color) {
        return ColorRoutines.getSaturation(color.getRed(), color.getGreen(), color.getBlue());
    }

    private static int getSaturation(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (n >= n2 && n >= n3) {
            if (n == 0) {
                return 0;
            }
            n6 = n;
            if (n2 >= n3) {
                n4 = n2;
                n5 = n3;
            } else {
                n5 = n2;
                n4 = n3;
            }
        } else if (n2 >= n && n2 >= n3) {
            n6 = n2;
            if (n >= n3) {
                n4 = n;
                n5 = n3;
            } else {
                n5 = n;
                n4 = n3;
            }
        } else if (n3 >= n && n3 >= n2) {
            n6 = n3;
            if (n >= n2) {
                n4 = n;
                n5 = n2;
            } else {
                n5 = n;
                n4 = n2;
            }
        }
        return 100 - (int)Math.round(100.0 * (double)n5 / (double)n6);
    }

    public static int getHue(Color color) {
        return ColorRoutines.getHue(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static int calculateHue(Color color) {
        hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsb);
        return (int)Math.round(360.0 * (double)hsb[0]);
    }

    private static int getHue(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 1;
        if (n >= n2 && n >= n3) {
            n6 = n;
            if (n2 == n3) {
                return 0;
            }
            if (n2 > n3) {
                n4 = n2;
                n5 = n3;
                n7 = 1;
            } else {
                n5 = n2;
                n4 = n3;
                n7 = 2;
            }
        } else if (n2 >= n && n2 >= n3) {
            n6 = n2;
            if (n == n3) {
                return 120;
            }
            if (n > n3) {
                n4 = n;
                n5 = n3;
                n7 = 4;
            } else {
                n5 = n;
                n4 = n3;
                n7 = 3;
            }
        } else if (n3 >= n && n3 >= n2) {
            n6 = n3;
            if (n == n2) {
                return 240;
            }
            if (n > n2) {
                n4 = n;
                n5 = n2;
                n7 = 5;
            } else {
                n5 = n;
                n4 = n2;
                n7 = 6;
            }
        }
        double d = (double)n4 * 255.0 / (double)n6;
        double d2 = (double)n5 * 255.0 / (double)n6;
        double d3 = (d - d2) * 255.0 / (255.0 - d2);
        int n8 = (int)Math.round(60.0 * d3 / 255.0);
        switch (n7) {
            case 1: {
                return n8;
            }
            case 2: {
                return 360 - n8;
            }
            case 3: {
                return 120 + n8;
            }
            case 4: {
                return 120 - n8;
            }
            case 5: {
                return 240 + n8;
            }
            case 6: {
                return 240 - n8;
            }
        }
        return -1;
    }

    int colorize(int n, int n2, int n3, int n4) {
        if (this.cbri == 100) {
            return ColorRoutines.colorToInt(255, 255, 255, n4);
        }
        if (this.cbri == -100) {
            return ColorRoutines.colorToInt(0, 0, 0, n4);
        }
        int n5 = n;
        if (n2 >= n && n2 >= n3) {
            n5 = n2;
        } else if (n3 >= n && n3 >= n2) {
            n5 = n3;
        }
        int n6 = n;
        if (n2 <= n && n2 <= n3) {
            n6 = n2;
        } else if (n3 <= n && n3 <= n2) {
            n6 = n3;
        }
        int n7 = (n5 + n6) / 2;
        if (this.preserveGrey && n == n2 && n == n3) {
            return ColorRoutines.colorToInt(n7, n7, n7, n4);
        }
        if (this.cbri < 0) {
            n7 += n7 * this.cbri / 100;
        } else if (this.cbri > 0) {
            n7 += (255 - n7) * this.cbri / 100;
        }
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        n11 = n7 >= 127 ? 255 - n7 : n7;
        if (this.hiIsR) {
            n8 = n7 + n11 * this.csat / 100;
        } else if (this.hiIsG) {
            n9 = n7 + n11 * this.csat / 100;
        } else if (this.hiIsB) {
            n10 = n7 + n11 * this.csat / 100;
        }
        if (this.mdIsR) {
            n11 = n7 >= 127 ? this.fr + (255 - this.fr) * (n7 - 127) / 128 - n7 : this.fr * n7 / 127 - n7;
            n8 = n7 + n11 * this.csat / 100;
        } else if (this.mdIsG) {
            n11 = n7 >= 127 ? this.fg + (255 - this.fg) * (n7 - 127) / 128 - n7 : this.fg * n7 / 127 - n7;
            n9 = n7 + n11 * this.csat / 100;
        } else if (this.mdIsB) {
            n11 = n7 >= 127 ? this.fb + (255 - this.fb) * (n7 - 127) / 128 - n7 : this.fb * n7 / 127 - n7;
            n10 = n7 + n11 * this.csat / 100;
        }
        n11 = n7 - (255 - n7);
        if (n11 < 0) {
            n11 = 0;
        }
        n11 = n7 - n11;
        if (this.loIsR) {
            n8 = n7 - n11 * this.csat / 100;
        } else if (this.loIsG) {
            n9 = n7 - n11 * this.csat / 100;
        } else if (this.loIsB) {
            n10 = n7 - n11 * this.csat / 100;
        }
        return ColorRoutines.colorToInt(n8, n9, n10, n4);
    }

    public static Color getAlphaColor(Color color, int n) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), n);
    }

    private static int colorToInt(int n, int n2, int n3, int n4) {
        return n3 + n2 * 256 + n * 65536 + n4 * 0x1000000;
    }

    public static Color lighten(Color color, int n) {
        if (n < 0) {
            return color;
        }
        if (n > 100) {
            n = 100;
        }
        int n2 = (int)Math.round((double)((255 - color.getRed()) * n) / 100.0);
        int n3 = (int)Math.round((double)((255 - color.getGreen()) * n) / 100.0);
        int n4 = (int)Math.round((double)((255 - color.getBlue()) * n) / 100.0);
        return new Color(color.getRed() + n2, color.getGreen() + n3, color.getBlue() + n4, color.getAlpha());
    }

    public static Color darken(Color color, int n) {
        if (n < 0 || n > 100) {
            return color;
        }
        int n2 = (int)Math.round((double)(color.getRed() * (100 - n)) / 100.0);
        int n3 = (int)Math.round((double)(color.getGreen() * (100 - n)) / 100.0);
        int n4 = (int)Math.round((double)(color.getBlue() * (100 - n)) / 100.0);
        return new Color(n2, n3, n4, color.getAlpha());
    }

    public static Color getAdjustedColor(Color color, int n, int n2) {
        int n3;
        int n4;
        int n5;
        Color color2 = color;
        if (n2 < 0) {
            color2 = ColorRoutines.darken(color, -n2);
        } else if (n2 > 0) {
            color2 = ColorRoutines.lighten(color, n2);
        }
        Color color3 = ColorRoutines.getMaxSaturation(color2, ColorRoutines.getHue(color));
        if (n >= 0) {
            int n6 = color2.getRed() - color3.getRed();
            int n7 = color2.getGreen() - color3.getGreen();
            int n8 = color2.getBlue() - color3.getBlue();
            n5 = color2.getRed() - (int)Math.round((double)(n6 * n) / 100.0);
            n4 = color2.getGreen() - (int)Math.round((double)(n7 * n) / 100.0);
            n3 = color2.getBlue() - (int)Math.round((double)(n8 * n) / 100.0);
        } else {
            float f = ColorRoutines.getGreyValue(color2);
            float f2 = (float)color2.getRed() - f;
            float f3 = (float)color2.getGreen() - f;
            float f4 = (float)color2.getBlue() - f;
            n5 = (int)Math.round((double)color2.getRed() + (double)(f2 * (float)n) / 100.0);
            n4 = (int)Math.round((double)color2.getGreen() + (double)(f3 * (float)n) / 100.0);
            n3 = (int)Math.round((double)color2.getBlue() + (double)(f4 * (float)n) / 100.0);
        }
        return new Color(n5, n4, n3);
    }

    public static boolean isColorDarker(Color color, Color color2) {
        return color.getRed() + color.getGreen() + color.getBlue() < color2.getRed() + color2.getGreen() + color2.getBlue();
    }
}

