/*
 * Decompiled with CFR 0.152.
 */
package com.efiAnalytics.tunerStudio.renderers;

import com.efiAnalytics.tunerStudio.dashboard.Gauge;
import com.efiAnalytics.tunerStudio.dashboard.aB;
import com.efiAnalytics.tunerStudio.renderers.GaugePainter;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;

public class VerticalBarPainter
implements GaugePainter {
    String name = "Vertical Bar Gauge";
    transient Image offImage = null;
    static final transient Color transparent = new Color(255, 255, 255, 0);

    @Override
    public void paintGauge(Graphics graphics, aB aB2) {
        Gauge gauge = (Gauge)aB2;
        if (gauge.isCounterClockwise()) {
            Image image = this.getOffImage(gauge);
            Graphics graphics2 = image.getGraphics();
            graphics2.setColor(transparent);
            ((Graphics2D)graphics2).setComposite(AlphaComposite.getInstance(2));
            graphics2.fillRect(0, 0, gauge.getWidth(), gauge.getHeight());
            this.paintBar(graphics2, gauge);
            this.paintBorder(graphics2, gauge);
            graphics.drawImage(image, 0, gauge.getHeight(), gauge.getWidth(), -gauge.getHeight(), null);
        } else {
            this.paintBar(graphics, gauge);
            this.paintBorder(graphics, gauge);
        }
    }

    protected void paintBar(Graphics graphics, Gauge gauge) {
        int n2;
        double d2 = (gauge.getSmoothedValue() - gauge.min()) / (gauge.max() - gauge.min());
        double d3 = (gauge.highWarning() - gauge.min()) / (gauge.max() - gauge.min());
        double d4 = (gauge.highCritical() - gauge.min()) / (gauge.max() - gauge.min());
        int n3 = gauge.getHeight() - (int)((double)gauge.getHeight() * d2);
        graphics.setColor(gauge.getBackColor());
        graphics.fillRect(0, 0, gauge.getWidth(), gauge.getHeight());
        graphics.setColor(gauge.getFontColor());
        graphics.fillRect(0, n3, gauge.getWidth(), gauge.getHeight() - n3);
        if (d2 > d3) {
            graphics.setColor(gauge.getWarnColor());
            n2 = (int)((double)gauge.getHeight() * (d2 - d3));
            graphics.fillRect(0, n3, gauge.getWidth(), n2);
        }
        if (d2 > d4) {
            graphics.setColor(gauge.getCriticalColor());
            n2 = (int)((double)gauge.getHeight() * (d2 - d4));
            graphics.fillRect(0, n3, gauge.getWidth(), n2);
        }
    }

    protected void paintBorder(Graphics graphics, Gauge gauge) {
        graphics.setColor(gauge.getTrimColor());
        for (int i2 = 0; i2 < gauge.getBorderWidth(); ++i2) {
            graphics.draw3DRect(i2, i2, gauge.getWidth() - 1 - 2 * i2, gauge.getHeight() - 1 - 2 * i2, gauge.getBorderWidth() / 2 >= i2);
        }
    }

    @Override
    public void invalidate() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void initialize(Gauge gauge) {
    }

    @Override
    public boolean isShapeLockedToAspect() {
        return false;
    }

    protected Image getOffImage(Gauge gauge) {
        if (this.offImage == null) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            this.offImage = graphicsConfiguration.createCompatibleImage(gauge.getWidth(), gauge.getHeight(), 3);
        }
        return this.offImage;
    }

    @Override
    public boolean requiresBackgroundRepaint(aB aB2) {
        return false;
    }

    @Override
    public void updateGauge(Graphics graphics, aB aB2) {
        Gauge gauge = (Gauge)aB2;
        if (gauge.isCounterClockwise()) {
            Image image = this.getOffImage(gauge);
            Graphics graphics2 = image.getGraphics();
            graphics2.setColor(transparent);
            ((Graphics2D)graphics2).setComposite(AlphaComposite.getInstance(2));
            graphics2.fillRect(0, 0, gauge.getWidth(), gauge.getHeight());
            this.paintBar(graphics2, gauge);
            graphics.drawImage(image, 0, gauge.getHeight(), gauge.getWidth(), -gauge.getHeight(), null);
        } else {
            this.paintBar(graphics, gauge);
        }
    }

    @Override
    public void paintBackground(Graphics graphics, aB aB2) {
        this.paintBorder(graphics, (Gauge)aB2);
    }

    @Override
    public Area areaPainted(aB aB2) {
        Gauge gauge = (Gauge)aB2;
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, gauge.getWidth(), gauge.getHeight());
        Area area = new Area(double_);
        return area;
    }
}

