/*
 * Decompiled with CFR 0.152.
 */
package com.efiAnalytics.tunerStudio.renderers;

import com.efiAnalytics.tunerStudio.dashboard.Gauge;
import com.efiAnalytics.tunerStudio.dashboard.aB;
import com.efiAnalytics.tunerStudio.renderers.GaugePainter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;

public class HorizontalDashedBar
implements GaugePainter {
    static String NAME = "Horizontal Dashed Bar Gauge";
    int inset = 10;
    int barCount = 20;
    transient Image backImage = null;
    int lastWidth = 0;
    int lastHeight = 0;

    @Override
    public void paintGauge(Graphics graphics, aB aB2) {
        Gauge gauge = (Gauge)aB2;
        graphics.drawImage(this.getBackImage(gauge), 0, 0, null);
        this.paintBar(graphics, gauge);
    }

    protected Image getBackImage(Gauge gauge) {
        if (this.backImage != null && this.backImage.getWidth(null) == gauge.getWidth() && this.backImage.getHeight(null) == gauge.getHeight()) {
            return this.backImage;
        }
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        Graphics graphics = null;
        this.backImage = graphicsConfiguration.createCompatibleImage(gauge.getWidth(), gauge.getHeight(), 2);
        graphics = this.backImage.getGraphics();
        Color color = new Color(0, 0, 0, 0);
        graphics.setColor(color);
        graphics.fillRect(0, 0, gauge.getWidth(), gauge.getHeight());
        this.inset = gauge.getBorderWidth() + 5;
        int n2 = gauge.getWidth() - 2 * this.inset;
        this.barCount = n2 / 7;
        double d2 = n2 / this.barCount;
        double d3 = 1.0;
        int n3 = gauge.getWidth() - this.inset - (int)d2;
        graphics.setColor(new Color(25, 25, 25));
        for (int i2 = 0; i2 < this.barCount; ++i2) {
            int n4 = (int)((double)i2 * d2);
            if (!((double)n4 - d2 / 4.0 < (double)n2 * d3)) continue;
            int n5 = n3 - n4;
            graphics.fillRect(n5, this.inset, (int)(d2 * 0.7), gauge.getHeight() - 2 * this.inset);
        }
        this.paintBackground(graphics, gauge);
        return this.backImage;
    }

    protected void paintBar(Graphics graphics, Gauge gauge) {
        double d2 = (gauge.getSmoothedValue() - gauge.min()) / (gauge.max() - gauge.min());
        double d3 = (gauge.highWarning() - gauge.min()) / (gauge.max() - gauge.min());
        double d4 = (gauge.highCritical() - gauge.min()) / (gauge.max() - gauge.min());
        int n2 = gauge.getWidth() - 2 * this.inset;
        this.barCount = n2 / 7;
        double d5 = n2 / this.barCount;
        int n3 = gauge.isCounterClockwise() ? gauge.getWidth() - this.inset - (int)d5 : this.inset;
        graphics.setColor(gauge.getFontColor());
        for (int i2 = 0; i2 < this.barCount; ++i2) {
            int n4;
            int n5 = (int)((double)i2 * d5);
            if (!((double)n5 - d5 / 4.0 < (double)n2 * d2)) continue;
            if ((double)n5 > d3 * (double)n2) {
                graphics.setColor(gauge.getWarnColor());
            }
            if ((double)n5 > d4 * (double)n2) {
                graphics.setColor(gauge.getCriticalColor());
            }
            if (gauge.isCounterClockwise()) {
                n4 = n3 - n5;
                graphics.fillRect(n4, this.inset, (int)(d5 * 0.7), gauge.getHeight() - 2 * this.inset);
                continue;
            }
            n4 = n3 + n5;
            graphics.fillRect(n4, this.inset, (int)(d5 * 0.7), gauge.getHeight() - 2 * this.inset);
        }
    }

    protected void paintBackground(Graphics graphics, Gauge gauge) {
        this.lastWidth = gauge.getWidth();
        this.lastHeight = gauge.getHeight();
        graphics.setColor(gauge.getBackColor());
        graphics.fillRect(0, 0, gauge.getWidth(), gauge.getHeight());
        if (gauge.backgroundImage() != null) {
            graphics.drawImage(gauge.backgroundImage(), 0, 0, gauge.getWidth(), gauge.getHeight(), null);
        }
        graphics.setColor(gauge.getTrimColor());
        for (int i2 = 0; i2 < gauge.getBorderWidth(); ++i2) {
            graphics.draw3DRect(i2, i2, gauge.getWidth() - 1 - 2 * i2, gauge.getHeight() - 1 - 2 * i2, gauge.getBorderWidth() / 2 >= i2);
        }
    }

    @Override
    public void invalidate() {
        this.backImage = null;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void initialize(Gauge gauge) {
    }

    @Override
    public boolean isShapeLockedToAspect() {
        return false;
    }

    @Override
    public boolean requiresBackgroundRepaint(aB aB2) {
        return aB2.getWidth() != this.lastWidth || aB2.getHeight() != this.lastWidth;
    }

    @Override
    public void updateGauge(Graphics graphics, aB aB2) {
        this.paintBar(graphics, (Gauge)aB2);
    }

    @Override
    public void paintBackground(Graphics graphics, aB aB2) {
        Gauge gauge = (Gauge)aB2;
        this.paintBackground(graphics, gauge);
    }

    @Override
    public Area areaPainted(aB aB2) {
        Gauge gauge = (Gauge)aB2;
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, gauge.getWidth(), gauge.getHeight());
        Area area = new Area(double_);
        return area;
    }
}

