/*
 * Decompiled with CFR 0.152.
 */
package com.efiAnalytics.tunerStudio.renderers;

import com.efiAnalytics.tunerStudio.dashboard.Gauge;
import com.efiAnalytics.tunerStudio.renderers.RoundAnalogGaugePainter;
import com.efiAnalytics.tunerStudio.renderers.g;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Stroke;

public class AnalogBarPainter
extends RoundAnalogGaugePainter {
    static String NAME = "Analog Bar Gauge";
    private g needleStroke = null;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    protected Image paintBackground(Graphics graphics, Gauge gauge, int n2) {
        if (this.parentGauge() == null) {
            this.setParentGauge(gauge);
        }
        Image image = super.paintBackground(graphics, gauge, this.currentState(gauge));
        Graphics2D graphics2D = (Graphics2D)image.getGraphics();
        double d2 = gauge.getSweepAngle();
        int n3 = Math.round(this.getNeedleWidth(gauge));
        int n4 = gauge.getBorderWidth() + n3 / 2;
        int n5 = gauge.getBorderWidth() + n3 / 2;
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setStroke(this.getNeedleStroke(gauge));
        graphics2D.setColor(gauge.getFontColor());
        if (gauge.isCounterClockwise()) {
            graphics2D.drawArc(n4, n5, this.getGaugeWidth(gauge) - n3 - 2 * gauge.getBorderWidth(), this.getGaugeHeight(gauge) - n3 - 2 * gauge.getBorderWidth(), 180 - gauge.getSweepBeginDegree() - gauge.getSweepAngle(), (int)Math.round(d2));
        } else {
            graphics2D.drawArc(n4, n5, this.getGaugeWidth(gauge) - n3 - 2 * gauge.getBorderWidth(), this.getGaugeHeight(gauge) - n3 - 2 * gauge.getBorderWidth(), gauge.getSweepBeginDegree() + gauge.getSweepAngle(), 0 - (int)Math.round(d2));
        }
        return image;
    }

    @Override
    protected void drawWarningIndicator(Graphics graphics, Gauge gauge) {
    }

    @Override
    protected void drawWarningBars(Graphics2D graphics2D, Gauge gauge) {
    }

    protected Color getNeedleColor(Gauge gauge) {
        return this.getNeedleColor(gauge, gauge.getValue());
    }

    protected Color getNeedleColor(Gauge gauge, double d2) {
        if (d2 > gauge.lowWarning() && d2 < gauge.highWarning()) {
            return gauge.getNeedleColor();
        }
        if (d2 > gauge.highCritical()) {
            return gauge.getCriticalColor();
        }
        return gauge.getWarnColor();
    }

    @Override
    protected void drawStrings(Graphics graphics, Gauge gauge) {
    }

    @Override
    protected double getOuterEdge(Gauge gauge) {
        if (gauge.getWidth() > gauge.getHeight()) {
            return 0.95 - (double)this.getNeedleWidthPercent() - 2.0 * (double)gauge.getBorderWidth() / (double)this.getGaugeHeight(gauge);
        }
        return 0.95 - (double)this.getNeedleWidthPercent() - 2.0 * (double)gauge.getBorderWidth() / (double)this.getGaugeWidth(gauge);
    }

    @Override
    protected double getNumberOfMinorTickPerMajor(Gauge gauge) {
        return 1.0;
    }

    @Override
    protected void drawNeedle(Graphics graphics, Gauge gauge, double d2) {
        double d3 = (gauge.getValue() - gauge.min()) / (gauge.max() - gauge.min());
        double d4 = d2;
        if (d4 < 1.0) {
            d4 = 1.0;
        }
        graphics.setColor(this.getNeedleColor(gauge));
        Polygon polygon = this.createNeedlePolygon(gauge, d4);
        graphics.fillPolygon(polygon);
        if (gauge.isShowHistory()) {
            double d5 = (gauge.getHistoricalPeakValue() - gauge.min()) / (gauge.max() - gauge.min());
            double d6 = (double)(gauge.getSweepBeginDegree() + gauge.getSweepAngle()) - (double)gauge.getSweepAngle() * d5;
            if (d5 - d3 > 0.01) {
                graphics.setColor(this.getNeedleColor(gauge, gauge.getHistoricalPeakValue()));
                Polygon polygon2 = this.createNeedlePolygon(gauge, d6);
                graphics.drawPolygon(polygon2);
            }
        }
    }

    protected Polygon createNeedlePolygon(Gauge gauge, double d2) {
        int n2 = this.getGaugeSize(gauge);
        double d3 = 1.005 - 2.0 * (double)gauge.getBorderWidth() / (double)n2;
        Polygon polygon = new Polygon();
        Point point = this.getPoint(n2, n2, d2 - 4.0, gauge.getWidth() / 2, gauge.getHeight() / 2, d3, gauge.isCounterClockwise());
        Point point2 = this.getPoint(n2, n2, d2 + 4.0, gauge.getWidth() / 2, gauge.getHeight() / 2, d3, gauge.isCounterClockwise());
        Point point3 = this.getPoint(n2, n2, d2 + 1.0, gauge.getWidth() / 2, gauge.getHeight() / 2, this.getOuterEdge(gauge) + 0.02, gauge.isCounterClockwise());
        Point point4 = this.getPoint(n2, n2, d2 - 1.0, gauge.getWidth() / 2, gauge.getHeight() / 2, this.getOuterEdge(gauge) + 0.02, gauge.isCounterClockwise());
        polygon.addPoint(point.x, point.y);
        polygon.addPoint(point2.x, point2.y);
        polygon.addPoint(point3.x, point3.y);
        polygon.addPoint(point4.x, point4.y);
        return polygon;
    }

    public float getNeedleWidthPercent() {
        return 0.09f;
    }

    public float getNeedleWidth(Gauge gauge) {
        return (float)this.getGaugeSize(gauge) * this.getNeedleWidthPercent();
    }

    public Stroke getNeedleStroke(Gauge gauge) {
        if (this.needleStroke == null) {
            float f2 = this.getNeedleWidth(gauge);
            this.needleStroke = new g(f2, 0, 2);
        }
        return this.needleStroke;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.needleStroke = null;
    }

    @Override
    public boolean isShapeLockedToAspect() {
        return true;
    }
}

